*Title: Debugging activeCollab
*Slug: debugging

================================================================

activeCollab can run in two different modes, based on the value of <{code}>APPLICATION_MODE<{/code}> directive. The possible values are:

- <{code}>in_production_mode<{/code}> - **the default mode used for the system in a production environment**. In case of a system error, activeCollab will display a brief error message to the user without revealing any sensitive system information. At the same time the system will send an email notification to the <{term}>Administrator<{/term}> with all the relevant information included. The notification recipient is configured with the <{code}>ADMIN_EMAIL<{/code}> directive.
- <{code}>in_debug_mode<{/code}> - **the debug mode is used for troubleshooting and development**. In this mode, activeCollab logs the entire execution process in the <{path}>/logs<{/path}> folder. Logged information is grouped by day. In case of a system error,   the details with all relevant system information are displayed to the user, but no email is sent.

When troubleshooting, set <{code}>APPLICATION_MODE<{/code}> to <{code}>in_debug_mode<{/code}>. Open <{path}>config/config.php<{/path}> and change the value of <{code}>APPLICATION_MODE<{/code}> to <{code}>in_debug_mode<{/code}>. If the <{code}>APPLICATION_MODE<{/code}> directive is not present in <{path}>config/config.php<{/path}>, add the following line to the file:

<{code}>define('APPLICATION_MODE', 'in_debug_mode');<{/code}>

It is strongly recommended that you use debug mode only for identifying and removing errors from the system. When done with the debugging, remove <{code}>APPLICATION_MODE<{/code}> from <{path}>config/config.php<{/path}> file to avoid revealing any sensitive information about your activeCollab setup.